


// Aggregate GECIR	
use "${tmp}\GECIR_2008.dta" , clear
ren *, lower
keep sirengt  siren l11 l14 l3
egen soustrait_pub = rsum(l11 l14)
rename l3 amt_jdoc
gen year = 2008
tempfile t8
save `t8'
use "${tmp}\GECIR_2009.dta" , clear
ren *, lower
keep sirengt siren l11? l14? l3
gen year = 2009
rename l3 amt_jdoc
egen soustrait_pub = rsum(l11? l14?)
tempfile t9
save `t9'
use "${tmp}\GECIR_2010.dta" , clear
ren *, lower
keep sirengt siren l12a l12b l15a l15b l4
gen year = 2010
rename l4 amt_jdoc
egen soustrait_pub = rsum(l12a l12b l15a l15b)
tempfile t10
save `t10'
use "${tmp}\GECIR_2011.dta" , clear
ren *, lower
keep sirengt  siren l17 l5
gen year = 2011
rename l5 amt_jdoc
ren l17 soustrait_pub
tempfile t11
save `t11'
use "${tmp}\GECIR_2012.dta" , clear
ren *, lower
keep sirengt  siren l17 l5
gen year = 2012
rename l5 amt_jdoc
ren l17 soustrait_pub
tempfile t12
save `t12'
use "${tmp}\GECIR_2013.dta" , clear
ren *, lower
keep sirengt  siren l17 l5
gen year = 2013
rename l5 amt_jdoc
ren l17 soustrait_pub
tempfile t13
save `t13'
use "${tmp}\GECIR_2014.dta" , clear
ren *, lower
keep sirengt  siren l17 l5
gen year = 2014
rename l5 amt_jdoc
ren l17 soustrait_pub
tempfile t14
save `t14'


use "${tmp}/dec_2069a_092020", clear
ren *, lower
gen year = real(cir_millesime)
egen t = rsum(l15a l15b l16a l16b)
replace l17 = t if mi(l17) | l17 < t
ren cx2 sirengt
rename l5 amt_jdoc
ren l17 soustrait_pub
keep if inrange(year,2015,2019)
forvalues y = 8/14 {
	append using `t`y''
	}
replace sirengt = siren if mi(sirengt)
keep year sirengt soustrait_pub amt_jdoc
destring sirengt, replace force

gcollapse (sum) soustrait_pub amt_jdoc, by(sirengt year)
drop if mi(sirengt)

ren sirengt siren_gf
merge 1:m siren_gf year using "${data}/Utils/Mere_fille_0420", keep(1 3) gen(_mmerefille)
replace siren = siren_gf if mi(siren)

**-- some duplicates because of multiple tg (should not happen)
gduplicates tag siren year, gen(dup)
drop if dup > 0 & siren_gf != siren // then keep the siren also present as siren fille

merge m:1 siren using "${data}/Utils/SirenZE_liasses.dta", keep(1 3) gen(_mliasseZE)
ren ZE2010 ZEliasse
merge 1:m siren year using "${tmp}/SirenZE_engineers_naf", gen(_mDADSshares) keep(1 3)
gcollapse (sum) job_eng_* (max) soustrait_pub amt_jdoc , by(siren_gf ZE2010 year ape)
keep if inrange(year,2005,2019)


bys siren year: gegen toteng_sbrut = sum(job_eng_sbrut)
bys siren year: gegen toteng_hrs = sum(job_eng_hrs)
gen share_eng_sbrut = job_eng_sbrut / toteng_sbrut 
gen share_eng_hrs = job_eng_hrs / toteng_hrs 

ren share_eng_hrs share

sort siren year
bys siren year: egen totshare = sum(share)
su totshare, d
bys siren year: egen maxshare = max(share)

set seed 789456123
bys siren_gf year: gen rdm = uniform()
bys siren_gf year maxshare: egen maxrdm = max(rdm) // to select one of the max at random if several max
replace maxshare = 1 if mi(maxshare)
replace maxrdm = (rdm==maxrdm)
bys siren_gf year: egen nbZE = nvals(ZE2010)
replace share = 1 if mi(share) & totshare == 0 & nbZE == 1


foreach var in amt_jdoc soustrait_pub {
	global var `var'
	gen ${var}_max 			= ${var} * maxshare * maxrdm
	global var1 = subinstr("$var","_pub","",1)

}

gcollapse (sum) *_max, by(ZE2010 ape year)

foreach var of varlist *_max {
	rename `var' `var'_gf
}

save "${tmp}/SoustraitPubCIR_ZE_NAF_groupfiscal", replace